ORCA/M Asm65816 2.1.0

0001 D200              *********************************************************************************
0002 D200              *                                                                               *
0003 D200              *                               GQuit - E1 segment                              *
0004 D200              *                                                                               *
0005 D200              *                       Copyright Apple Computer, Inc. 1986-1993                *
0006 D200              *                                                                               *
0007 D200              *                               All Rights Reserved                             *
0008 D200              *                                                                               *
0009 D200              *********************************************************************************
0010 D200
0011 D200              *********************************************************************************
0012 D200                       SEG   'seg_e1'
0013 D200              org_dummy_7 proc org e1_obj_pstn, noskip
0014 D200                       endp 
0015 D200              *********************************************************************************
0016 D200
0017 D200
0018 D200                       eject 
0019 D200              ;===============================================================================
0020 D200              ; p8_mount_vol
0021 D200              ;
0022 D200              ; Entry is in 16-bit native mode.
0023 D200              ; Exit is in 16-bit native mode.
0024 D200              ; Data bank register is unknown.
0025 D200              ;
0026 D200              ; Inputs:       A - error code
0027 D200              ;
0028 D200              ; Outputs:      A - error code (hi byte set to 0)
0029 D200              ;               c - 0 if mount volume window put up and 'return' was pressed
0030 D200              ;                   1 if window not put up or if window put up and 'esc' pressed
0031 D200              ;
0032 D200              ; Notes:        Must exit with an RTL since called from bank 0 code.
0033 D200              ;
0034 D200              ; If the error code is volume_not_found ($45) or no disk in drive ($2F),
0035 D200              ; then put up a window asking the user to insert the needed volume.
0036 D200              ;===============================================================================
0037 D200
0038 D200              p8_mount_vol PROC 
0039 D200                       DataChk off
0040 D200
0041 D200                       longa on
0042 D200                       longi on
0043 D200
0044 D200 A0 E1 00              ldy   #e1_app_volname>>16      ;set up ptr to volume name
0045 D203 A2 3B D7              ldx   #e1_app_volname
0046 D206
0047 D206              ; If the p8_mount_vol2 entry point is called, X and Y must already be set up.
0048 D206
0049 D206                       EXPORT p8_mount_vol2
0050 D206              p8_mount_vol2  
0051 D206
0052 D206              ; If error code is 'volume not found' or 'no disk in drive' then put up the
0053 D206              ; Mount Volume window, otherwise return with carry set.
0054 D206
0055 D206 29 FF 00              and   #$00ff                   ;just in case
0056 D209 C9 45 00              cmp   #vol_not_found
0057 D20C F0 07                 beq   cont
0058 D20E C9 2F 00              cmp   #drvr_off_line
0059 D211 F0 02                 beq   cont
0060 D213 38                    sec                            ;indicate error not handled
0061 D214 6B                    rtl                            ;error code still in A
0062 D215
0063 D215              cont      
0064 D215 48                    pha                            ;save error code in case ESC pressed
0065 D216 5A                    phy                            ;push ptr to volume name on stack
0066 D217 DA                    phx   
0067 D218 3B                    tsc   
0068 D219 0B                    phd                            ;save D reg
0069 D21A 5B                    tcd                            ;point D reg at stack
0070 D21B A7 01                 lda   [<1]                     ;get length byte and leading separator
0071 D21D 3A                    dec   a                        ;don't count leading separator
0072 D21E EB                    xba                            ;then swap the bytes so the volume name
0073 D21F 87 01                 sta   [<1]                     ;does not contain the separator
0074 D221
0075 D221 48                    pha                            ; Room for result
0076 D222 F4 E1 00              pea   e1_mount_msg>>16
0077 D225 F4 4B D9              pea   e1_mount_msg
0078 D228 5A                    phy                            ; hi word of ptr to volume name
0079 D229 E8                    inx                            ; skip separator
0080 D22A DA                    phx                            ; lo word of ptr to volume name
0081 D22B F4 E1 00              pea   e1_btn1_label>>16        ; 'Return'
0082 D22E F4 63 D9              pea   e1_btn1_label
0083 D231
0084 D231 F4 E1 00              pea   e1_btn2_label>>16        ; 'Escape'
0085 D234 F4 71 D9              pea   e1_btn2_label
0086 D237 A2 01 12 22           _TLTextMountVolume 
0087 D23E A7 01                 lda   [<1]                     ;restore first 2 bytes of volume name
0088 D240 EB                    xba                            ;back to their original positions
0089 D241 1A                    inc   a                        ;and values
0090 D242 87 01                 sta   [<1]
0091 D244 68                    pla                            ;Which button: 1=Return, 2=Escape
0092 D245 2B                    pld                            ;restore D reg
0093 D246 FA                    plx                            ;pull volume name ptr off stack
0094 D247 FA                    plx   
0095 D248 C9 01 00              cmp   #1                       ;which button was pressed?
0096 D24B D0 03                 bne   escape_pressed
0097 D24D 18                    clc                            ;indicate Return was pressed
0098 D24E 68                    pla                            ;pull original error code off stack
0099 D24F 6B                    rtl                            ;return with carry clear
0100 D250
0101 D250 38           escape_pressed sec                      ;Indicate Escape was pressed
0102 D251 68                    pla                            ;restore error code
0103 D252 6B                    rtl                            ;return with carry set
0104 D253
0105 D253                       DataChk on
0106 D253                       ENDP 
0107 D253
0108 D253
0109 D253
0110 D253                       eject 
0111 D253              ;===============================================================================
0112 D253              ; p8_prefix_err
0113 D253              ;
0114 D253              ; Entry is in 16-bit native mode.
0115 D253              ; Exit is in 16-bit native mode.
0116 D253              ; Data bank register is unknown.
0117 D253              ;
0118 D253              ; Inputs:       A - error code
0119 D253              ;               e1_prefix_buf - contains the prefix being used to set ProDOS 8's
0120 D253              ;                               prefix
0121 D253              ;
0122 D253              ; Outputs:      X - lo word of ptr to volume name
0123 D253              ;               Y - hi word of ptr to volume name
0124 D253              ;               A - error code
0125 D253              ;
0126 D253              ; Notes:        This routine jumps into the p8_mount_vol routine at the entry
0127 D253              ;               point p8_mount_vol2.  Control does not return to this routine.
0128 D253              ;
0129 D253              ; An error occurred while trying to set ProDOS 8's prefix.  So we need to
0130 D253              ; set up X and Y to point to the correct volume name so that the 'mount volume'
0131 D253              ; message will have the correct volume name.
0132 D253              ;===============================================================================
0133 D253
0134 D253              p8_prefix_err PROC 
0135 D253                       DataChk off
0136 D253
0137 D253                       longa on
0138 D253                       longi on
0139 D253
0140 D253 48                    pha                            ;save error code
0141 D254
0142 D254              ;adjust length of e1_prefix_buf to only contain the length of the volume name
0143 D254              ;since the prefix may be a pathname
0144 D254
0145 D254                       longa off
0146 D254                       longi off
0147 D254 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
0148 D256
0149 D256 A2 01                 ldx   #1                       ;skip leading slash
0150 D258 8A           loop     txa   
0151 D259 CF 2A D8 E1           cmp   >e1_prefix_buf           ;at end of string?
0152 D25D F0 0F                 beq   done                     ;yes
0153 D25F E8                    inx   
0154 D260 BF 2A D8 E1           lda   >e1_prefix_buf,x
0155 D264 C9 2F                 cmp   #'/'
0156 D266 D0 F0                 bne   loop                     ;loop until find a slash
0157 D268 CA                    dex                            ;don't count slash
0158 D269 8A                    txa   
0159 D26A 8F 2A D8 E1           sta   >e1_prefix_buf           ;store new length byte
0160 D26E              done      
0161 D26E
0162 D26E                       longa on
0163 D26E                       longi on
0164 D26E C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
0165 D270
0166 D270 A0 E1 00              ldy   #e1_prefix_buf>>16       ;set up ptr to volume name
0167 D273 A2 2A D8              ldx   #e1_prefix_buf
0168 D276 68                    pla                            ;retrieve error code
0169 D277 5C 06 D2 E1           jmp   >p8_mount_vol2           ;put up the mount volume message
0170 D27B
0171 D27B                       DataChk on
0172 D27B                       ENDP 
0173 D27B
0174 D27B
0175 D27B                       eject 
0176 D27B              ;===============================================================================
0177 D27B              ; get_stacked_id
0178 D27B              ;
0179 D27B              ; Entry is in 16-bit native mode.
0180 D27B              ; Exit is in 16-bit native mode.
0181 D27B              ; Data bank register is unknown.
0182 D27B              ; Direct register is unknown.
0183 D27B              ;
0184 D27B              ; Inputs:       none
0185 D27B              ;
0186 D27B              ; Outputs:      A - ID of next item on ID stack, 0 if stack empty
0187 D27B              ;
0188 D27B              ; Notes:        Must return with an RTL since called from SCM.
0189 D27B              ;
0190 D27B              ; This routine returns the ID of the next item on the ID stack.
0191 D27B              ; If the ID stack is empty, it returns 0.
0192 D27B              ; This routine is called by SCM in response to a system service call.
0193 D27B              ;===============================================================================
0194 D27B
0195 D27B                       EXPORT get_stacked_id
0196 D27B              get_stacked_id PROC 
0197 D27B
0198 D27B                       longa on
0199 D27B                       longi on
0200 D27B
0201 D27B AF 9F D6 E1           lda   >e1_id_stack_index       ;get current stack index
0202 D27F F0 09                 beq   done                     ;0 if stack is empty
0203 D281 3A                    dec   a                        ;adjust index to point to
0204 D282 3A                    dec   a                        ;next ID on stack
0205 D283 3A                    dec   a
0206 D284 3A                    dec   a
0207 D285 AA                    tax   
0208 D286 BF A1 D6 E1           lda   >e1_id_stack,x           ;get the ID
0209 D28A 6B           done     rtl   
0210 D28B
0211 D28B                       ENDP 
0212 D28B
0213 D28B
0214 D28B
0215 D28B                       eject 
0216 D28B              ;===============================================================================
0217 D28B              ; rename_bootvol
0218 D28B              ;
0219 D28B              ; Entry is in 16-bit native mode.
0220 D28B              ; Exit is in 16-bit native mode.
0221 D28B              ; Data bank register is unknown.
0222 D28B              ; Direct register is preserved.
0223 D28B              ;
0224 D28B              ; Inputs:       X - lo word of pointer to string
0225 D28B              ;               Y - hi word of pointer to string
0226 D28B              ;
0227 D28B              ; Outputs:      c - 0 if no error ; 1 if error
0228 D28B              ;               A - error code if c=1
0229 D28B              ;
0230 D28B              ; Notes:        Must return with an RTL since called from SCM.
0231 D28B              ;
0232 D28B              ; Called by SCM when the boot volume has been renamed.
0233 D28B              ; The string containing the new boot volume name is in class 1 format and has
0234 D28B              ; a leading colon but not an ending colon.
0235 D28B              ;===============================================================================
0236 D28B
0237 D28B                       EXPORT rename_bootvol
0238 D28B              rename_bootvol PROC 
0239 D28B
0240 D28B              string_ptr equ   3                      ;offset into stack
0241 D28B
0242 D28B 5A                    phy                            ;push string pointer onto stack
0243 D28C DA                    phx   
0244 D28D
0245 D28D              ldr_ok    
0246 D28D
0247 D28D 0B                    phd                            ;save direct register
0248 D28E 3B                    tsc                            ;set direct register to point to stack
0249 D28F 5B                    tcd   
0250 D290
0251 D290 A7 03                 lda   [<string_ptr]            ;get length word
0252 D292 1A                    inc   a                        ;add 1 for extra length byte
0253 D293 A8                    tay   
0254 D294 AA                    tax   
0255 D295
0256 D295 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
0257 D297                       longa off
0258 D297                       longi off
0259 D297
0260 D297 B7 03        loop     lda   [<string_ptr],y          ;copy new volume name into
0261 D299 9F F7 D6 E1           sta   >e1_volname,x            ;GQuit's data area
0262 D29D 88                    dey   
0263 D29E CA                    dex   
0264 D29F 10 F6                 bpl   loop                     ;loop until done with string
0265 D2A1
0266 D2A1 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
0267 D2A3                       longa on
0268 D2A3                       longi on
0269 D2A3
0270 D2A3 2B                    pld                            ;restore direct register
0271 D2A4 68                    pla                            ;clean up stack
0272 D2A5 68                    pla   
0273 D2A6
0274 D2A6 22 8B D3 E1           jsl   make_start_paths         ;create the start program pathnames
0275 D2AA
0276 D2AA 6B                    rtl   
0277 D2AB
0278 D2AB                       ENDP 
0279 D2AB                       eject 
0280 D2AB              ;===============================================================================
0281 D2AB              ; concat
0282 D2AB              ;
0283 D2AB              ; Entry is in 16-bit native mode.
0284 D2AB              ; Exit is in 16-bit native mode.
0285 D2AB              ; Data bank register is preserved.
0286 D2AB              ; Direct register is preserved.
0287 D2AB              ;
0288 D2AB              ; Inputs:       SP+15 = 0 if class 0 strings, 1 if class 1 strings
0289 D2AB              ;               SP+11 = Address of String1
0290 D2AB              ;               SP+7  = Address of String2
0291 D2AB              ;               SP+3  = Address of String3 (result string)
0292 D2AB              ;               SP+1  = Return address - 1 (From the JSL)
0293 D2AB              ;
0294 D2AB              ; Outputs:      none
0295 D2AB              ;
0296 D2AB              ; Notes:        Any altered stack usage will alter stack equate values!
0297 D2AB              ;               Must return with an RTL since called from GLDR and B0 code.
0298 D2AB              ;
0299 D2AB              ; Concat will concatinate two strings and place the result in a third string.
0300 D2AB              ; The strings may be all class 0 strings or all class 1 strings.
0301 D2AB              ; String1 and String3 may be the same string.
0302 D2AB              ;===============================================================================
0303 D2AB
0304 D2AB              concat   PROC 
0305 D2AB
0306 D2AB              ; equates for direct register addressing
0307 D2AB
0308 D2AB              class    equ   19
0309 D2AB              ptr1     equ   15
0310 D2AB              ptr2     equ   11
0311 D2AB              ptr3     equ   7
0312 D2AB
0313 D2AB
0314 D2AB                       longa on
0315 D2AB                       longi on
0316 D2AB
0317 D2AB 8B                    phb                            ; Save current bank.
0318 D2AC F4 E1 E1              pea   $e1e1
0319 D2AF AB                    plb                            ; set data bank reg to bank $E1
0320 D2B0 AB                    plb   
0321 D2B1
0322 D2B1 0B                    phd                            ; Save D. (Note stack indexing consequences!)
0323 D2B2 3B                    tsc                            ; Equate D to S for addressing access.
0324 D2B3 5B                    tcd   
0325 D2B4
0326 D2B4                       longa off
0327 D2B4                       longi off
0328 D2B4 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
0329 D2B6
0330 D2B6 A7 0B                 lda   [<ptr2]                  ; get length of string2
0331 D2B8 A8                    tay                            ; save for later
0332 D2B9 18                    clc   
0333 D2BA 67 0F                 adc   [<ptr1]                  ; add to length of string1
0334 D2BC 87 07                 sta   [<ptr3]                  ; to get length of string3
0335 D2BE AA                    tax                            ; save length of string3 in X
0336 D2BF
0337 D2BF A5 13                 lda   <class                   ; class 1 strings?
0338 D2C1 F0 02                 beq   class0                   ; no
0339 D2C3 C8                    iny                            ; yes - so add 1 for extra length byte
0340 D2C4 E8                    inx   
0341 D2C5              class0    
0342 D2C5
0343 D2C5 B7 0B        copystr2 lda   [<ptr2],y                ; first copy string2 into string3
0344 D2C7 5A                    phy                            ; save string2's index
0345 D2C8 9B                    txy                            ; get string3's index
0346 D2C9 97 07                 sta   [<ptr3],y
0347 D2CB BB                    tyx                            ; save string3's index
0348 D2CC 7A                    ply                            ; retrieve string2's index
0349 D2CD CA                    dex   
0350 D2CE 88                    dey   
0351 D2CF C4 13                 cpy   <class                   ; stop at byte 0 if class 0 strings
0352 D2D1 D0 F2                 bne   copystr2                 ; stop at byte 1 if class 1 strings
0353 D2D3
0354 D2D3                       longa on
0355 D2D3                       longi on
0356 D2D3 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
0357 D2D5
0358 D2D5 A5 0F                 lda   <ptr1                    ; if the ptr to string1 is the same
0359 D2D7 C5 07                 cmp   <ptr3                    ; as the ptr to string3 then don't
0360 D2D9 D0 06                 bne   not_equal                ; bother copying string1 into string3
0361 D2DB A5 11                 lda   <ptr1+2                  ; since they are the same string
0362 D2DD C5 09                 cmp   <ptr3+2                  ; and the length byte has already
0363 D2DF F0 18                 beq   copy_done                ; been changed
0364 D2E1              not_equal  
0365 D2E1
0366 D2E1                       longa off
0367 D2E1                       longi off
0368 D2E1 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
0369 D2E3
0370 D2E3 A7 0F                 lda   [<ptr1]                  ; get length of string1
0371 D2E5 A8                    tay   
0372 D2E6
0373 D2E6 A5 13                 lda   <class                   ; class 1 strings?
0374 D2E8 F0 01                 beq   class00                  ; no
0375 D2EA C8                    iny                            ; yes - so add 1 for extra length byte
0376 D2EB              class00   
0377 D2EB
0378 D2EB B7 0F        copystr1 lda   [<ptr1],y                ; now copy string1 into string3
0379 D2ED 5A                    phy                            ; save string1's index
0380 D2EE 9B                    txy                            ; get string3's index
0381 D2EF 97 07                 sta   [<ptr3],y
0382 D2F1 BB                    tyx                            ; save string3's index
0383 D2F2 7A                    ply                            ; retrieve string1's index
0384 D2F3 CA                    dex   
0385 D2F4 88                    dey   
0386 D2F5 D0 F4                 bne   copystr1                 ; loop until done copying string1
0387 D2F7
0388 D2F7                       longa on
0389 D2F7                       longi on
0390 D2F7 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
0391 D2F9
0392 D2F9              copy_done  
0393 D2F9 2B                    pld                            ; Restore Direct reg. (Changes stack indexing!)
0394 D2FA AB                    plb                            ; Restore caller's DBR.
0395 D2FB
0396 D2FB A3 01                 lda   1,s                      ; Now move up the 3 byte return address...
0397 D2FD 83 0F                 sta   15,s                     ; to proper place in the stack.
0398 D2FF A3 02                 lda   2,s                      ; We're forced to move the middle return byte twice..
0399 D301 83 10                 sta   16,s
0400 D303 3B                    tsc                            ; Adjust stack up to spot below return adr.
0401 D304 18                    clc   
0402 D305 69 0E 00              adc   #14
0403 D308 1B                    tcs                            ; Set S to proper return value.
0404 D309 6B                    rtl   
0405 D30A                       ENDP 
0406 D30A
0407 D30A
0408 D30A
0409 D30A                       eject 
0410 D30A              ;===============================================================================
0411 D30A              ; compare_string
0412 D30A              ;
0413 D30A              ; Entry is in 16-bit native mode.
0414 D30A              ; Exit is in 16-bit native mode.
0415 D30A              ; Data bank register is preserved.
0416 D30A              ; Direct register is preserved.
0417 D30A              ;
0418 D30A              ; Inputs:       4 bytes - pointer to string 1
0419 D30A              ;               4 bytes - pointer to string 2
0420 D30A              ;               3 bytes - return address
0421 D30A              ;
0422 D30A              ; Outputs:      c - 0 if strings match, 1 if strings don't match.
0423 D30A              ;
0424 D30A              ; Notes:        Must return with an RTL since called from GLDR and B0 code.
0425 D30A              ;
0426 D30A              ; This routine compares two class 1 strings to see if they are the same.
0427 D30A              ; This routine does a case-insensitive compare.
0428 D30A              ;===============================================================================
0429 D30A
0430 D30A              compare_string PROC 
0431 D30A
0432 D30A                       longa on
0433 D30A                       longi on
0434 D30A
0435 D30A              str1char equ   1
0436 D30A              ptr2     equ   9
0437 D30A              ptr1     equ   13
0438 D30A
0439 D30A 8B                    phb                            ;save data bank register
0440 D30B 0B                    phd                            ;save direct register
0441 D30C 48                    pha                            ;make space to store char
0442 D30D 3B                    tsc   
0443 D30E 5B                    tcd                            ;set direct register to stack
0444 D30F
0445 D30F A7 0D                 lda   [<ptr1]                  ; Get length of string1.
0446 D311 C7 09                 cmp   [<ptr2]                  ; Is it the same length as string2?
0447 D313 D0 1C                 bne   notsame                  ; no
0448 D315 1A                    inc   a                        ; add 1 for extra length byte
0449 D316 A8                    tay   
0450 D317
0451 D317 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
0452 D319                       longa off
0453 D319                       longi off
0454 D319
0455 D319 B7 0D        nextchar lda   [<ptr1],y                ; get char from string1
0456 D31B 20 40 D3              jsr   cvt_to_upper             ; convert to upper case
0457 D31E 85 01                 sta   <str1char                ; and save on stack
0458 D320 B7 09                 lda   [<ptr2],y                ; get char from string2
0459 D322 20 40 D3              jsr   cvt_to_upper             ; convert to upper case
0460 D325 C5 01                 cmp   <str1char                ; cmpare chars
0461 D327 D0 08                 bne   notsame
0462 D329 88                    dey   
0463 D32A D0 ED                 bne   nextchar
0464 D32C
0465 D32C C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
0466 D32E                       longa on
0467 D32E                       longi on
0468 D32E 18                    clc                            ; Indicate that the strings matched
0469 D32F 80 03                 bra   done
0470 D331
0471 D331 C2 30        notsame  rep   #$30                     ;***** return to 16-bit mode *****
0472 D333                       longa on
0473 D333                       longi on
0474 D333 38                    sec                            ; Set carry denoting no match
0475 D334
0476 D334              done      
0477 D334 68                    pla                            ; pull char storage off stack
0478 D335 2B                    pld                            ; restore direct register
0479 D336 FA                    plx                            ; pull B, RTN1 off stack
0480 D337 7A                    ply                            ; pull RTN2, RTN3 off stack
0481 D338 68                    pla                            ; pull inputs off stack
0482 D339 68                    pla   
0483 D33A 68                    pla   
0484 D33B 68                    pla   
0485 D33C 5A                    phy                            ; push RTN2, RTN3 back on stack
0486 D33D DA                    phx                            ; push B, RTN1 back on stack
0487 D33E AB                    plb                            ; restore data bank
0488 D33F 6B                    rtl   
0489 D340
0490 D340              ;-------------------------------------------------------------------------------
0491 D340
0492 D340              ; If the character in A is a lower-case alphabetic character then convert it
0493 D340              ; to upper-case.
0494 D340
0495 D340              cvt_to_upper  
0496 D340                       longa off
0497 D340                       longi off
0498 D340
0499 D340 C9 61                 cmp   #'a'
0500 D342 90 07                 bcc   cvt_done
0501 D344 C9 7B                 cmp   #'{'
0502 D346 B0 03                 bcs   cvt_done
0503 D348 38                    sec   
0504 D349 E9 20                 sbc   #$20
0505 D34B 60           cvt_done rts   
0506 D34C
0507 D34C                       ENDP 
0508 D34C
0509 D34C
0510 D34C
0511 D34C                       eject 
0512 D34C              ;===============================================================================
0513 D34C              ; slash_2_colon
0514 D34C              ;
0515 D34C              ; Entry is in 16-bit native mode.
0516 D34C              ; Exit is in 16-bit native mode.
0517 D34C              ; Data bank register is unknown.
0518 D34C              ; Direct register is preserved.
0519 D34C              ;
0520 D34C              ; Inputs:       X - lo word of pointer to string
0521 D34C              ;               Y - hi word of pointer to string
0522 D34C              ;
0523 D34C              ; Outputs:      none
0524 D34C              ;
0525 D34C              ; Scans a class 1 string and converts all slashes (/) to colons (:).
0526 D34C              ;===============================================================================
0527 D34C
0528 D34C              slash_2_colon PROC 
0529 D34C
0530 D34C              string_ptr equ   3                      ;offset into stack
0531 D34C
0532 D34C 5A                    phy                            ;push string pointer onto stack
0533 D34D DA                    phx   
0534 D34E
0535 D34E 0B                    phd                            ;save direct register
0536 D34F 3B                    tsc                            ;set direct register to point to stack
0537 D350 5B                    tcd   
0538 D351
0539 D351 A7 03                 lda   [<string_ptr]            ;get length word
0540 D353 F0 13                 beq   xlate_done               ;quit if length is 0
0541 D355 A8                    tay   
0542 D356 C8                    iny                            ;add 1 for extra length byte
0543 D357
0544 D357 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
0545 D359                       longa off
0546 D359                       longi off
0547 D359
0548 D359 B7 03        xlate_loop lda   [<string_ptr],y        ;get next character
0549 D35B C9 2F                 cmp   #'/'                     ;is it a slash?
0550 D35D D0 04                 bne   xlate_cont               ;no
0551 D35F A9 3A                 lda   #':'                     ;yes - so replace it with a colon
0552 D361 97 03                 sta   [<string_ptr],y
0553 D363 88           xlate_cont dey   
0554 D364 D0 F3                 bne   xlate_loop               ;loop until done with string
0555 D366
0556 D366 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
0557 D368                       longa on
0558 D368                       longi on
0559 D368              xlate_done  
0560 D368 2B                    pld                            ;restore direct register
0561 D369 68                    pla                            ;clean up stack
0562 D36A 68                    pla   
0563 D36B 6B                    rtl   
0564 D36C
0565 D36C                       ENDP 
0566 D36C
0567 D36C
0568 D36C
0569 D36C                       eject 
0570 D36C              ;===============================================================================
0571 D36C              ; colon_2_slash
0572 D36C              ;
0573 D36C              ; Entry is in 16-bit native mode.
0574 D36C              ; Exit is in 16-bit native mode.
0575 D36C              ; Data bank register is unknown.
0576 D36C              ; Direct register is preserved.
0577 D36C              ;
0578 D36C              ; Inputs:       X - lo word of pointer to string
0579 D36C              ;               Y - hi word of pointer to string
0580 D36C              ;
0581 D36C              ; Outputs:      none
0582 D36C              ;
0583 D36C              ; Scans a class 0 string and converts all colons (:) to slashes (/).
0584 D36C              ;===============================================================================
0585 D36C
0586 D36C              colon_2_slash PROC 
0587 D36C
0588 D36C              string_ptr equ   3                      ;offset into stack
0589 D36C
0590 D36C 5A                    phy                            ;push string pointer onto stack
0591 D36D DA                    phx   
0592 D36E
0593 D36E 0B                    phd                            ;save direct register
0594 D36F 3B                    tsc                            ;set direct register to point to stack
0595 D370 5B                    tcd   
0596 D371
0597 D371 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
0598 D373                       longa off
0599 D373                       longi off
0600 D373
0601 D373 A7 03                 lda   [<string_ptr]            ;get length byte
0602 D375 F0 0E                 beq   xlate_done               ;quit if length is 0
0603 D377 A8                    tay   
0604 D378
0605 D378 B7 03        xlate_loop lda   [<string_ptr],y        ;get next character
0606 D37A C9 3A                 cmp   #':'                     ;is it a colon?
0607 D37C D0 04                 bne   xlate_cont               ;no
0608 D37E A9 2F                 lda   #'/'                     ;yes - so replace it with a slash
0609 D380 97 03                 sta   [<string_ptr],y
0610 D382 88           xlate_cont dey   
0611 D383 D0 F3                 bne   xlate_loop               ;loop until done with string
0612 D385              xlate_done  
0613 D385
0614 D385 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
0615 D387                       longa on
0616 D387                       longi on
0617 D387
0618 D387 2B                    pld                            ;restore direct register
0619 D388 68                    pla                            ;clean up stack
0620 D389 68                    pla   
0621 D38A 6B                    rtl   
0622 D38B
0623 D38B                       ENDP 
0624 D38B
0625 D38B
0626 D38B
0627 D38B                       eject 
0628 D38B              ;===============================================================================
0629 D38B              ; make_start_paths
0630 D38B              ;
0631 D38B              ; Entry is in 16-bit native mode.
0632 D38B              ; Exit is in 16-bit native mode.
0633 D38B              ; Data bank register is unknown.
0634 D38B              ; Direct register is unknown.
0635 D38B              ;
0636 D38B              ; Inputs:       e1_volname -  contains the name of the boot volume
0637 D38B              ;                             in class 1 format
0638 D38B              ;               e1_sys_filename - contains the filename of the start program
0639 D38B              ;                                 in class 0 format
0640 D38B              ;
0641 D38B              ; Outputs:      e1_start_prog0 - contains the pathname of the start program
0642 D38B              ;                                in class 0 format
0643 D38B              ;               e1_start_prog1 - contains the pathname of the start program
0644 D38B              ;                                in class 1 format
0645 D38B              ;
0646 D38B              ; Notes:        Must return with an RTL since called from GLDR and E0 code.
0647 D38B              ;===============================================================================
0648 D38B
0649 D38B              make_start_paths PROC  
0650 D38B                       DataChk off
0651 D38B
0652 D38B                       longa on
0653 D38B                       longi on
0654 D38B
0655 D38B              ; first, convert e1_volname into class 0 format
0656 D38B
0657 D38B AF F7 D6 E1           lda   >e1_volname              ; get length word
0658 D38F EB                    xba   
0659 D390 8F F7 D6 E1           sta   >e1_volname              ; and swap bytes for class 0 format
0660 D394
0661 D394              ; now create a class 1 version of the start program pathname
0662 D394
0663 D394 F4 00 00              pea   0                        ; indicate class 0 strings
0664 D397 F4 E1 00              pea   e1_volname>>16           ; Push ptr to string1
0665 D39A F4 F8 D6              pea   e1_volname+1
0666 D39D F4 E1 00              pea   e1_sys_filename>>16      ; Push ptr to string2
0667 D3A0 F4 DF D8              pea   e1_sys_filename
0668 D3A3 F4 E1 00              pea   e1_start_prog1>>16       ; Push ptr to resultant string
0669 D3A6 F4 A2 D7              pea   e1_start_prog1+1
0670 D3A9 22 AB D2 E1           jsl   concat
0671 D3AD
0672 D3AD AF A1 D7 E1           lda   >e1_start_prog1          ;get length of full pathname
0673 D3B1 29 00 FF              and   #$ff00
0674 D3B4 EB                    xba                            ;swap bytes to make it a
0675 D3B5 8F A1 D7 E1           sta   >e1_start_prog1          ;class 1 length word
0676 D3B9
0677 D3B9              ; now create a class 0 version of the start program pathname
0678 D3B9
0679 D3B9 F4 00 00              pea   0                        ; indicate class 0 strings
0680 D3BC F4 E1 00              pea   e1_volname>>16           ; Push ptr to string1
0681 D3BF F4 F8 D6              pea   e1_volname+1
0682 D3C2 F4 E1 00              pea   e1_sys_filename>>16      ; Push ptr to string2
0683 D3C5 F4 DF D8              pea   e1_sys_filename
0684 D3C8 F4 E1 00              pea   e1_start_prog0>>16       ; Push ptr to resultant string
0685 D3CB F4 5E D7              pea   e1_start_prog0
0686 D3CE 22 AB D2 E1           jsl   concat
0687 D3D2
0688 D3D2              ; convert e1_volname back to class 1 format
0689 D3D2
0690 D3D2 AF F7 D6 E1           lda   >e1_volname              ; get length word
0691 D3D6 EB                    xba   
0692 D3D7 8F F7 D6 E1           sta   >e1_volname              ; and swap bytes back to class 1 format
0693 D3DB
0694 D3DB              ; now scan the class 0 pathname and translate the colons into slashes
0695 D3DB
0696 D3DB A0 E1 00              ldy   #e1_start_prog0>>16      ;get pointer to string in X and Y
0697 D3DE A2 5E D7              ldx   #e1_start_prog0
0698 D3E1 22 6C D3 E1           jsl   colon_2_slash            ;convert colons to slashes
0699 D3E5
0700 D3E5 6B                    rtl   
0701 D3E6
0702 D3E6                       DataChk on
0703 D3E6                       ENDP 
0704 D3E6
0705 D3E6                       eject 
0706 D3E6              ;===============================================================================
0707 D3E6              ; init_text_tools
0708 D3E6              ;
0709 D3E6              ; Entry is in 16-bit native mode.
0710 D3E6              ; Exit is in 16-bit native mode.
0711 D3E6              ; Data bank register is set to bank $E1 on entry and exit.
0712 D3E6              ;
0713 D3E6              ; Inputs:       none
0714 D3E6              ;
0715 D3E6              ; Outputs:      none
0716 D3E6              ;
0717 D3E6              ; Notes:        The calling routine does not care if there are any errors when
0718 D3E6              ;               this routine is called so we don't check for any and save lots
0719 D3E6              ;               of bytes for missing bcs's.
0720 D3E6              ;
0721 D3E6              ; This routine is called before P16 applications are launched so they
0722 D3E6              ; can immediately utilize character I/O.
0723 D3E6              ;
0724 D3E6              ; Moved to bank $E1 to make a little room in bank $E0, 02/17/91, GAB.
0725 D3E6              ;
0726 D3E6              ;===============================================================================
0727 D3E6
0728 D3E6              init_text_tools PROC 
0729 D3E6
0730 D3E6                       longa on
0731 D3E6                       longi on
0732 D3E6
0733 D3E6              ; Make the following Text Tool Set calls -
0734 D3E6              ; SetInGlobals ($090c), SetOutGlobals ($0a0c), SetErrGlobals ($0b0c)
0735 D3E6              ; These calls set the 'global AND mask' and the 'global OR mask' for the
0736 D3E6              ; input device, the output device and the error output device.
0737 D3E6
0738 D3E6 A2 0C 09              ldx   #$090c
0739 D3E9 DA           loop1    phx                            ;save counter for later
0740 D3EA F4 FF 00              pea   $00ff                    ;global AND mask for device
0741 D3ED F4 80 00              pea   $0080                    ;global OR mask for device
0742 D3F0 22 00 00 E1           jsl   >dispatch1
0743 D3F4 18                    clc   
0744 D3F5 68                    pla                            ;get counter
0745 D3F6 69 00 01              adc   #$0100
0746 D3F9 AA                    tax   
0747 D3FA C9 0C 0C              cmp   #$0c0c
0748 D3FD 90 EA                 bcc   loop1                    ;do until carry set
0749 D3FF
0750 D3FF              ; Make the following Text Tool Set calls -
0751 D3FF              ; SetInputDevice ($0f0c), SetOutputDevice ($100c), SetErrorDevice ($110c)
0752 D3FF              ; These calls set the input device, the output device and the error output
0753 D3FF              ; device to a Pascal type device in slot 3.
0754 D3FF
0755 D3FF A2 0C 0F              ldx   #$0f0c
0756 D402 DA           loop2    phx                            ;save counter for later
0757 D403 F4 01 00              pea   $0001                    ;pascal device type
0758 D406 F4 00 00              pea   $0000
0759 D409 F4 03 00              pea   $0003                    ;slot 3
0760 D40C 22 00 00 E1           jsl   >dispatch1
0761 D410 18                    clc   
0762 D411 68                    pla                            ;get counter
0763 D412 69 00 01              adc   #$0100
0764 D415 AA                    tax   
0765 D416 C9 0C 12              cmp   #$120c
0766 D419 90 E7                 bcc   loop2                    ;do until carry set
0767 D41B
0768 D41B              ; Make the following Text Tool Set call -
0769 D41B              ; InitTextDev ($150c) to initialize the input device ($0000), the error output
0770 D41B              ; device ($0001) and the output device ($0002)
0771 D41B              ; Note - only do this if slot 3 is set internal
0772 D41B
0773 D41B AF 17 C0 00           lda   >rdc3rom                 ;slot 3 status is in bit 7
0774 D41F EB                    xba                            ;swap bytes so bit 7 is now in bit 15
0775 D420 30 10                 bmi   done                     ;branch if slot 3 is set external
0776 D422
0777 D422 A9 02 00              lda   #$0002
0778 D425 48           loop3    pha                            ;save counter for later
0779 D426 48                    pha                            ;pretend like pea instruction
0780 D427 A2 0C 15              ldx   #$150c                   ;init it
0781 D42A 22 00 00 E1           jsl   >dispatch1
0782 D42E 68                    pla                            ;get counter
0783 D42F 3A                    dec   a
0784 D430 D0 F3                 bne   loop3                    ;do until 0
0785 D432
0786 D432 6B           done     rtl   
0787 D433
0788 D433                       ENDP 
0789 D433
0790 D433                       eject 
0791 D433              ;===============================================================================
0792 D433              ; call_launcher
0793 D433              ;
0794 D433              ; Entry is in 16-bit native mode.
0795 D433              ; Exit is in 16-bit native mode.
0796 D433              ; Data bank register is set to bank $E1 on entry and exit.
0797 D433              ;
0798 D433              ; Inputs:       none
0799 D433              ;
0800 D433              ; Outputs:      pointer to pathname in path1_ptr
0801 D433              ;               UserID of Launcher in X
0802 D433              ;
0803 D433              ;
0804 D433              ; This routine is called when there is no application ID on the quit
0805 D433              ; stack to return to.  Instead of simply launching the start application
0806 D433              ; again, the old Program Launcher will be presented to the user to allow
0807 D433              ; her to select the next application to launch.
0808 D433              ;
0809 D433              ;===============================================================================
0810 D433
0811 D433              call_launcher PROC 
0812 D433                       DataChk off
0813 D433
0814 D433              new_userID equ   1
0815 D433              handle   equ   3
0816 D433
0817 D433 3B                    tsc                            ;make local direct page
0818 D434 38                    sec   
0819 D435 E9 06 00              sbc   #6                       ;need 6 bytes of local storage
0820 D438 1B                    tcs   
0821 D439 0B                    phd   
0822 D43A 5B                    tcd   
0823 D43B
0824 D43B 48                    pha                            ;result space
0825 D43C F4 00 30              pea   $3000                    ;use GS/OS id type
0826 D43F A2 03 20              ldx   #$2003                   ;GetNewID
0827 D442 22 00 00 E1           jsl   $E10000
0828 D446 A3 01                 lda   1,s                      ;retrieve new ID, but leave on stack
0829 D448 85 01                 sta   new_userID
0830 D44A
0831 D44A A2 1E 02              ldx   #$021e                   ;ResourceStartup call
0832 D44D 22 00 00 E1           jsl   $E10000
0833 D451
0834 D451 48                    pha                            ;result space
0835 D452 48                    pha   
0836 D453 A2 03 34              ldx   #$3403                   ;GetCodeResConverter
0837 D456 22 00 00 E1           jsl   $E10000
0838 D45A              ; leave proc pointer on stack for following call
0839 D45A
0840 D45A F4 17 80              pea   $8017                    ;rCodeResource
0841 D45D F4 01 00              pea   1                        ;logFlags
0842 D460 A2 1E 28              ldx   #$281e                   ;ResourceConverter
0843 D463 22 00 00 E1           jsl   $E10000
0844 D467
0845 D467 AF F6 B9 00           lda   >sys_prefs               ;get preferences flag
0846 D46B 48                    pha                            ;save for a bit
0847 D46C A9 00 C0              lda   #$C000                   ;set to show mount dialog w/o cancel button
0848 D46F 8F F6 B9 00           sta   >sys_prefs
0849 D473
0850 D473 48                    pha                            ;result space
0851 D474 48                    pha   
0852 D475 F4 17 80              pea   $8017                    ;rCodeResource
0853 D478 F4 FF 07              pea   $07ff                    ;resource id ($07ff0001)
0854 D47B F4 01 00              pea   $0001
0855 D47E A2 1E 0E              ldx   #$0e1e                   ;LoadResource
0856 D481 22 00 00 E1           jsl   $E10000
0857 D485 FA                    plx                            ;retrieve handle
0858 D486 86 03                 stx   handle
0859 D488 FA                    plx   
0860 D489 86 05                 stx   handle+2
0861 D48B FA                    plx                            ;retrieve old sysPrefs
0862 D48C 90 04                 bcc   @loaded_ok               ;no error, continue
0863 D48E 5C D2 DF E0           jmp   >p8_fatal_err2
0864 D492
0865 D492              @loaded_ok  
0866 D492 8A                    txa   
0867 D493 8F F6 B9 00           sta   >sys_prefs               ;restore system preferences
0868 D497
0869 D497 A0 01 00              ldy   #1
0870 D49A B7 03                 lda   [handle],y               ;deref the returned handle
0871 D49C 8F A8 D4 E1           sta   >vector+2                ;store the address (self modifying code)
0872 D4A0 A7 03                 lda   [handle]
0873 D4A2 8F A7 D4 E1           sta   >vector+1
0874 D4A6
0875 D4A6 22 00 00 00  vector   jsl   >$000000                 ;address is self-modified
0876 D4AA
0877 D4AA              ; deref the returned handle
0878 D4AA 98                    tya                            ;high word into Acc
0879 D4AB 8B                    phb                            ;save DBR
0880 D4AC EB                    xba   
0881 D4AD 48                    pha   
0882 D4AE AB                    plb   
0883 D4AF AB                    plb                            ;set DBR to bank of Handle
0884 D4B0 BD 00 00              lda   |0,x                     ;address of Pointer
0885 D4B3 BC 02 00              ldy   |2,x                     ;bank of Pointer
0886 D4B6 AB                    plb                            ;restore DBR
0887 D4B7 18                    clc                            ;adjust past buffer length word
0888 D4B8 69 02 00              adc   #2
0889 D4BB 90 01                 bcc   @1
0890 D4BD C8                    iny   
0891 D4BE              @1        
0892 D4BE 5A                    phy                            ;save pointer on stack
0893 D4BF 48                    pha   
0894 D4C0
0895 D4C0 F4 03 00              pea   3                        ;purge level
0896 D4C3 F4 17 80              pea   $8017                    ;rCodeResource
0897 D4C6 F4 FF 07              pea   $07ff                    ;resource id
0898 D4C9 F4 01 00              pea   $0001
0899 D4CC A2 1E 17              ldx   #$171e                   ;ReleaseResource
0900 D4CF 22 00 00 E1           jsl   $E10000
0901 D4D3
0902 D4D3 A2 1E 03              ldx   #$031E                   ;ResourceShutdown
0903 D4D6 22 00 00 E1           jsl   $E10000
0904 D4DA
0905 D4DA 68                    pla                            ;retrieve pathname pointer
0906 D4DB 7A                    ply   
0907 D4DC
0908 D4DC A6 01                 ldx   new_userID               ;return userID
0909 D4DE 2B                    pld                            ;restore original direct page
0910 D4DF
0911 D4DF 85 3A                 sta   <path1_ptr               ;store the pointer
0912 D4E1 84 3C                 sty   <path1_ptr+2
0913 D4E3
0914 D4E3 68                    pla                            ;clean up stack
0915 D4E4 68                    pla   
0916 D4E5 68                    pla   
0917 D4E6
0918 D4E6 6B                    rtl                            ;back to get_next_prog
0919 D4E7
0920 D4E7                       EndP 
0921 D4E7
0922 D4E7                       eject 
0923 D4E7              ;===============================================================================
0924 D4E7              ; dispose_os_mem
0925 D4E7              ;
0926 D4E7              ; Entry is in 16-bit native mode.
0927 D4E7              ; Exit is in 16-bit native mode.
0928 D4E7              ; Data bank register is set to bank $E1 on entry and exit.
0929 D4E7              ;
0930 D4E7              ; Inputs:       e1_os_mem_id - contains the ID used by GLDR and GQuit when
0931 D4E7              ;                              allocating reserved memory segments.
0932 D4E7              ;
0933 D4E7              ; Outputs:      c - 0 if no error, 1 if error
0934 D4E7              ;               A - error code if c=1
0935 D4E7              ;
0936 D4E7              ; Disposes of all memory segments which were allocated using the segment ID
0937 D4E7              ; e1_os_mem_id.
0938 D4E7              ;===============================================================================
0939 D4E7
0940 D4E7              dispose_os_mem PROC 
0941 D4E7                       DataChk off
0942 D4E7
0943 D4E7                       longa on
0944 D4E7                       longi on
0945 D4E7
0946 D4E7 AD 55 D6              lda   |e1_os_mem_id
0947 D4EA 80 03                 bra   do_dispose
0948 D4EC
0949 D4EC
0950 D4EC                       eject 
0951 D4EC              ;===============================================================================
0952 D4EC              ; dispose_storage
0953 D4EC              ;
0954 D4EC              ; Entry is in 16-bit native mode.
0955 D4EC              ; Exit is in 16-bit native mode.
0956 D4EC              ; Data bank register is set to bank $E1 on entry and exit.
0957 D4EC              ;
0958 D4EC              ; Inputs:       e1_storage_id - contains the ID used by GQuit when
0959 D4EC              ;                               allocating storage space for GS/OS.
0960 D4EC              ;
0961 D4EC              ; Outputs:      c - 0 if no error, 1 if error
0962 D4EC              ;               A - error code if c=1
0963 D4EC              ;
0964 D4EC              ; Disposes of all memory segments which were allocated using the segment ID
0965 D4EC              ; e1_storage_id.
0966 D4EC              ;===============================================================================
0967 D4EC
0968 D4EC                       Entry dispose_storage
0969 D4EC              dispose_storage  
0970 D4EC                       longa on
0971 D4EC                       longi on
0972 D4EC
0973 D4EC AD 57 D6              lda   |e1_storage_id
0974 D4EF              do_dispose  
0975 D4EF 48                    pha   
0976 D4F0 A2 02 11 22           _DisposAll 
0977 D4F7 6B                    rtl   
0978 D4F8
0979 D4F8                       DataChk on
0980 D4F8                       ENDP 
0981 D4F8
0982 D4F8
0983 D4F8
0984 D4F8                       eject 
0985 D4F8              ;===============================================================================
0986 D4F8              ; dispose_user_zp
0987 D4F8              ;
0988 D4F8              ; Entry is in 16-bit native mode.
0989 D4F8              ; Exit is in 16-bit native mode.
0990 D4F8              ; Data bank register is unknown.
0991 D4F8              ;
0992 D4F8              ; Inputs:       e1_zp_handle - contains the handle to the zero page
0993 D4F8              ;
0994 D4F8              ; Outputs:      c - 0 if no error, 1 if error
0995 D4F8              ;               A - error code if c=1
0996 D4F8              ;
0997 D4F8              ; Notes:        Must return with an RTL since called from GLDR and E0 code.
0998 D4F8              ;
0999 D4F8              ; This routine checks to see if GQuit allocated the zero page segment and if so
1000 D4F8              ; it disposes of it.
1001 D4F8              ;===============================================================================
1002 D4F8
1003 D4F8              dispose_user_zp PROC 
1004 D4F8
1005 D4F8                       longa on
1006 D4F8                       longi on
1007 D4F8
1008 D4F8 AF 99 D6 E1           lda   >e1_zp_handle+2          ; Put handle on the stack first then
1009 D4FC 48                    pha                            ; see if it's nil
1010 D4FD AF 97 D6 E1           lda   >e1_zp_handle
1011 D501 48                    pha   
1012 D502 03 03                 ora   3,s
1013 D504 F0 29                 beq   its_nil
1014 D506 A2 02 10 22           _DisposeHandle                 ;wasn't nil so dispose it
1015 D50D AA                    tax                            ;save error temporarily
1016 D50E A9 00 00              lda   #0
1017 D511 8F 97 D6 E1           sta   >e1_zp_Handle            ;set handle to nil
1018 D515 8F 99 D6 E1           sta   >e1_zp_Handle+2
1019 D519 8A                    txa                            ;retrieve error code
1020 D51A 6B                    rtl   
1021 D51B
1022 D51B                       eject 
1023 D51B              ;===============================================================================
1024 D51B              ; dispose_path
1025 D51B              ;
1026 D51B              ; Entry is in 16-bit native mode.
1027 D51B              ; Exit is in 16-bit native mode.
1028 D51B              ; Data bank register is set to bank $E1 on entry and exit.
1029 D51B              ;
1030 D51B              ; Inputs:       e1_path_hndl - contains the handle to the pathname copy
1031 D51B              ;
1032 D51B              ; Outputs:      c - 0 if no error, 1 if error
1033 D51B              ;               A - error code if c=1
1034 D51B              ;
1035 D51B              ; This routine checks to see if a copy of the Quit pathname was made and if so
1036 D51B              ; it disposes of the memory which was allocated to hold the copy.
1037 D51B              ;===============================================================================
1038 D51B
1039 D51B                       entry dispose_path
1040 D51B              dispose_path  
1041 D51B
1042 D51B                       longa on
1043 D51B                       longi on
1044 D51B
1045 D51B AD 6D D6              lda   |e1_path_hndl+2          ;put handle on stack first then
1046 D51E 48                    pha                            ;see if it's nil
1047 D51F AD 6B D6              lda   |e1_path_hndl
1048 D522 48                    pha   
1049 D523 03 03                 ora   3,s
1050 D525 F0 08                 beq   its_nil
1051 D527 A2 02 10 22           _DisposeHandle                 ;wasn't nil so dispose it
1052 D52E 6B                    rtl   
1053 D52F
1054 D52F              its_nil                                 ;nothing to do so clean up stack
1055 D52F 68                    pla   
1056 D530 68                    pla   
1057 D531 18                    clc                            ;indicate no error
1058 D532 6B                    rtl   
1059 D533
1060 D533                       ENDP 
1061 D533
1062 D533
1063 D533
1064 D533                       eject 
1065 D533              ;===============================================================================
1066 D533              ;
1067 D533              ; e1_data
1068 D533              ;
1069 D533              ;===============================================================================
1070 D533
1071 D533              e1_data  PROC 
1072 D533
1073 D533              ;-------------------------------------------------------------------------------
1074 D533              ; Tables
1075 D533              ;-------------------------------------------------------------------------------
1076 D533
1077 D533                       EXPORT e1_gsos_segs
1078 D533              e1_gsos_segs  
1079 D533 00 00                 DC W:0                         ;language card bank (0/1)
1080 D535 00 D0 00 00           DC L:$00D000                   ;starting address
1081 D539 00 30                 DC W:$3000                     ;size in bytes
1082 D53B 00 00 00 00           DC L:0                         ;handle to storage area
1083 D53F
1084 D53F 01 00                 DC W:1                         ;language card bank (0/1)
1085 D541 00 D0 00 00           DC L:$00D000                   ;starting address
1086 D545 00 10                 DC W:$1000                     ;size in bytes
1087 D547 00 00 00 00           DC L:0                         ;handle to storage area
1088 D54B
1089 D54B 00 00                 DC W:0                         ;language card bank (0/1)
1090 D54D 00 D0 01 00           DC L:$01D000                   ;starting address
1091 D551 00 30                 DC W:$3000                     ;size in bytes
1092 D553 00 00 00 00           DC L:0                         ;handle to storage area
1093 D557
1094 D557 01 00                 DC W:1                         ;language card bank (0/1)
1095 D559 00 D0 01 00           DC L:$01D000                   ;starting address
1096 D55D 00 10                 DC W:$1000                     ;size in bytes
1097 D55F 00 00 00 00           DC L:0                         ;handle to storage area
1098 D563
1099 D563                       EXPORT e1_gsos_segs2
1100 D563              e1_gsos_segs2  
1101 D563              ; SCM's bank 0 memory
1102 D563 00 00                 DC W:0                         ;language card bank (0/1)
1103 D565 00 9A 00 00           DC L:SCM_Start                 ;starting address
1104 D569 00 26                 DC W:$C000-SCM_Start           ;size in bytes
1105 D56B 00 00 00 00           DC L:0                         ;handle to storage area
1106 D56F
1107 D56F              ; 1K for use by AppleDisk 3.5 driver Scatter Read routines
1108 D56F 00 00                 DC W:0                         ;language card bank (0/1)
1109 D571 00 BC 01 00           DC L:$01BC00                   ;starting address
1110 D575 00 04                 DC W:$0400                     ;size in bytes
1111 D577 00 00 00 00           DC L:0                         ;handle to storage area
1112 D57B
1113 D57B              ; for use by System Loader
1114 D57B 00 00                 DC W:0                         ;language card bank (0/1)
1115 D57D 00 A6 01 00           DC L:Loader_Entry              ;starting address
1116 D581 00 16                 DC W:$1BC00-Loader_Entry       ;size
1117 D583 00 00 00 00           DC L:0                         ;handle to storage area
1118 D587
1119 D587 FF FF                 DC W:$ffff                     ;terminator
1120 D589
1121 D589
1122 D589              ;-------------------------------------------------------------------------------
1123 D589              ; GS/OS parameter lists
1124 D589              ;-------------------------------------------------------------------------------
1125 D589
1126 D589                       EXPORT e1_setpfx0_parms
1127 D589              e1_setpfx0_parms                        ;SetPrefix 0 - class 0 parameter list
1128 D589 00 00                 DC W:0                         ;set prefix 0/
1129 D58B 2A D8 E1 00           DC L:e1_prefix_buf             ;ptr to prefix
1130 D58F
1131 D58F                       EXPORT e1_gbv_parms
1132 D58F              e1_gbv_parms                            ;GetBootVol - class 0 parameter list
1133 D58F 2A D8 E1 00           DC L:e1_prefix_buf             ;ptr to prefix buffer
1134 D593
1135 D593
1136 D593                       EXPORT e1_getpfx_parms1
1137 D593                       EXPORT e1_getpfx_num
1138 D593              e1_getpfx_parms1                        ;GetPrefix - class 1 parameter list
1139 D593 02 00                 DC W:2                         ;parameter count
1140 D595 00 00        e1_getpfx_num DS B:2                    ;prefix #
1141 D597 28 D8 E1 00           DC L:e1_prefix_buf1            ;ptr to prefix buffer
1142 D59B
1143 D59B                       EXPORT e1_setpfx_parms1
1144 D59B                       EXPORT e1_setpfx_num
1145 D59B                       EXPORT e1_setpfx_ptr
1146 D59B              e1_setpfx_parms1                        ;SetPrefix - class 1 parameter list
1147 D59B 02 00                 DC W:2                         ;parameter count
1148 D59D 01 00        e1_setpfx_num DS B:2                    ;prefix #
1149 D59F E2 0F 02 00  e1_setpfx_ptr DS B:4                    ;ptr to prefix
1150 D5A3
1151 D5A3                       EXPORT e1_setpfx2_parms1
1152 D5A3              e1_setpfx2_parms1                       ;SetPrefix 2 - class 1 parameter list
1153 D5A3 02 00                 DC W:2                         ;parameter count
1154 D5A5 02 00                 DC W:2                         ;set prefix 2/
1155 D5A7 0E D9 E1 00           DC L:e1_lib_path               ;ptr to prefix
1156 D5AB
1157 D5AB                       EXPORT e1_open_parms1
1158 D5AB                       EXPORT e1_open_ref
1159 D5AB                       EXPORT e1_open_path
1160 D5AB              e1_open_parms1                          ;Open - class 1 parameter list
1161 D5AB 03 00                 DC W:3                         ;parameter count
1162 D5AD 00 00        e1_open_ref DS B:2                      ;reference number
1163 D5AF 01 D9 E1 00  e1_open_path DC L:e1_p8_path            ;pointer to pathname
1164 D5B3 01 00                 DC W:1                         ;read access
1165 D5B5
1166 D5B5                       EXPORT e1_close_parms1
1167 D5B5                       EXPORT e1_close_ref
1168 D5B5              e1_close_parms1                         ;Close - class 1 parameter list
1169 D5B5 01 00                 DC W:1                         ;parameter count
1170 D5B7 00 00        e1_close_ref DS B:2                     ;reference number
1171 D5B9
1172 D5B9                       EXPORT e1_read_parms1
1173 D5B9                       EXPORT e1_read_ref
1174 D5B9                       EXPORT e1_read_buf
1175 D5B9                       EXPORT e1_read_count
1176 D5B9              e1_read_parms1                          ;Read - class 1 parameter list
1177 D5B9 04 00                 DC W:4                         ;parameter count
1178 D5BB 00 00        e1_read_ref DS B:2                      ;reference number.
1179 D5BD 00 20 00 00  e1_read_buf DC L:$2000                  ;pointer to read buffer.
1180 D5C1 00 00 00 00  e1_read_count DS B:4                    ;number of bytes to read.
1181 D5C5 00 00 00 00           DS B:4                         ;unused
1182 D5C9
1183 D5C9                       EXPORT e1_geof_parms1
1184 D5C9                       EXPORT e1_geof_ref
1185 D5C9                       EXPORT e1_geof_eof
1186 D5C9              e1_geof_parms1                          ;GetEOF - class 1 parameter list
1187 D5C9 02 00                 DC W:2                         ;parameter count
1188 D5CB 00 00        e1_geof_ref DS B:2                      ;reference number
1189 D5CD 00 00 00 00  e1_geof_eof DS B:4                      ;eof
1190 D5D1
1191 D5D1                       EXPORT e1_gfi_parms1
1192 D5D1                       EXPORT e1_gfi_ptr
1193 D5D1                       EXPORT e1_gfi_ftype
1194 D5D1                       EXPORT e1_gfi_atype
1195 D5D1                       EXPORT e1_gfi_eof
1196 D5D1              e1_gfi_parms1                           ;GetFileInfo - class 1 parameter list
1197 D5D1 09 00                 DC W:9                         ;parameter count
1198 D5D3 E2 0F 02 00  e1_gfi_ptr DS B:4                       ;ptr to pathname
1199 D5D7 E3 00                 DS B:2                         ;access
1200 D5D9 B3 00        e1_gfi_ftype DS B:2                     ;filetype
1201 D5DB 03 DB 00 00  e1_gfi_atype DS B:4                     ;auxtype
1202 D5DF 05 00 00 34           DS B:18                        ;unused fields
1203 D5F1 F9 D5 E1 00           DC L:e1_option_list
1204 D5F5 EC 3D 02 00  e1_gfi_eof DS B:4                       ;eof
1205 D5F9
1206 D5F9                       Export e1_fst_id
1207 D5F9 30 00        e1_option_list DC W:48                  ;option list total size
1208 D5FB 02 00                 DS W:1                         ;space for returned size
1209 D5FD 01 00        e1_fst_id DS W:1                        ;space for returned FST ID
1210 D5FF 00 00 00 00           DS B:44                        ;remainder of option list
1211 D62B
1212 D62B                       EXPORT e1_sess_parms1
1213 D62B              e1_sess_parms1                          ;EndSession - class 1 parameter list
1214 D62B 00 00                 DC W:0                         ;parameter count
1215 D62D
1216 D62D                       EXPORT e1_gdn_parms1
1217 D62D                       EXPORT e1_gdn_ptr
1218 D62D                       EXPORT e1_gdn_dnum
1219 D62D              e1_gdn_parms1                           ;GetDevNumber - class 1 parameter list
1220 D62D 02 00                 DC W:2                         ;parameter count
1221 D62F 1D D9 E1 00  e1_gdn_ptr DS B:4                       ;ptr to volume name
1222 D633 04 00        e1_gdn_dnum DS B:2                      ;device number
1223 D635
1224 D635                       EXPORT e1_volume_parms1
1225 D635                       EXPORT e1_volume_ptr
1226 D635                       EXPORT e1_volume_id
1227 D635              e1_volume_parms1                        ;Volume - class 1 parameter list
1228 D635 05 00                 DC W:5                         ;parameter count
1229 D637 00 00 00 00  e1_volume_ptr DC L:0                    ;ptr to device name (initialize to 0)
1230 D63B 28 D8 E1 00           DC L:e1_prefix_buf1            ;ptr to volume name - unused
1231 D63F 00 00 00 00           DS B:4                         ;total blocks - unused
1232 D643 00 00 00 00           DS B:4                         ;free blocks - unused
1233 D647 00 00        e1_volume_id DS B:2                     ;file system ID
1234 D649
1235 D649                       EXPORT e1_fst_parms1
1236 D649                       EXPORT e1_fst_ptr
1237 D649              e1_fst_parms1                           ;FST Specific - class 1 parameter list
1238 D649 03 00                 DC W:3                         ;parameter count
1239 D64B 0D 00                 DC W:appleshare_id             ;fst #
1240 D64D 08 00                 DC W:8                         ;command #
1241 D64F 00 00 00 00  e1_fst_ptr DS B:4                       ;ptr to pathname
1242 D653
1243 D653              ;-------------------------------------------------------------------------------
1244 D653              ; general storage
1245 D653              ;-------------------------------------------------------------------------------
1246 D653
1247 D653                       EXPORT e1_word_temp
1248 D653 01 00        e1_word_temp DS B:2                     ;scratch word
1249 D655                       EXPORT e1_os_mem_id
1250 D655 01 32        e1_os_mem_id DS B:2                     ;ID assigned to GS/OS and P8 reserved memory
1251 D657                       EXPORT e1_storage_id
1252 D657 03 32        e1_storage_id DS B:2                    ;ID assigned to GS/OS storage
1253 D659                       EXPORT e1_p8copy_id
1254 D659 04 32        e1_p8copy_id DS B:2                     ;ID assigned to copy of P8
1255 D65B                       EXPORT e1_p8copy_hndl
1256 D65B 00 00 00 00  e1_p8copy_hndl DS B:4                   ;handle to copy of P8
1257 D65F                       EXPORT e1_p8copy_ptr
1258 D65F 00 00 00 00  e1_p8copy_ptr DS B:4                    ;pointer to copy of P8
1259 D663                       EXPORT e1_p8copy_size
1260 D663 00 00 00 00  e1_p8copy_size DS B:4                   ;size of copy of P8
1261 D667                       EXPORT e1_p8copy_flag
1262 D667 FF FF        e1_p8copy_flag DC W:$ffff               ;$ffff-no hndl;0-purged hndl;1-valid hndl
1263 D669                       EXPORT e1_path_id
1264 D669 02 32        e1_path_id DS B:2                       ;ID assigned to Quit pathname data area
1265 D66B                       EXPORT e1_path_hndl
1266 D66B 00 65 E0 00  e1_path_hndl DS B:4                     ;handle to pathname data area
1267 D66F                       EXPORT e1_path_ptr
1268 D66F E2 0F 02 00  e1_path_ptr DS B:4                      ;ptr to pathname of program to launch
1269 D673                       EXPORT e1_path_len
1270 D673 0C 00        e1_path_len DS B:2                      ;length of partial path of program to launch
1271 D675                       EXPORT e1_drvr_id
1272 D675 00 00        e1_drvr_id DC W:0                       ;ID assigned to boot driver (init to 0)
1273 D677                       EXPORT e1_user_id
1274 D677 01 10        e1_user_id DS B:2                       ;user's segment ID
1275 D679                       EXPORT e1_current_id
1276 D679 01 10        e1_current_id DS B:2                    ;ID of S16 prog that called QUIT
1277 D67B                       EXPORT e1_open_id
1278 D67B 00 00        e1_open_id DS B:2                       ;ID of S16 prog to be launched
1279 D67D                       EXPORT e1_quit_prefix
1280 D67D 20 00        e1_quit_prefix DS B:2                   ;prefix # from QUIT pathname parameter
1281 D67F                       EXPORT e1_quit_flags
1282 D67F 00 00        e1_quit_flags DS B:2                    ;flags from P16 QUIT parameters
1283 D681                       EXPORT e1_current_os
1284 D681 00 00        e1_current_os DS B:2                    ;$8000=ProDOS 8,  $0000=GS/OS
1285 D683                       EXPORT e1_load_type
1286 D683 B3 00        e1_load_type DS B:2                     ;$00FF=SYS prog,  $00B3=S16 prog
1287 D685                       EXPORT e1_aux_type
1288 D685 03 DB        e1_aux_type DS B:2                      ;aux type of S16 prog to be launched
1289 D687                       EXPORT e1_start_flag
1290 D687 00 00        e1_start_flag DS B:2                    ;1 if relaunching start prog, 0 if not
1291 D689                       EXPORT e1_full_path
1292 D689 00 00        e1_full_path DS B:2                     ;1 if using full pathname, 0 if partial
1293 D68B                       EXPORT e1_appleshare
1294 D68B 00 00        e1_appleshare DC W:0                    ;<>0 if AppleShare FST loaded, 0 if not
1295 D68D                       EXPORT e1_no_storage
1296 D68D 00 00        e1_no_storage DS B:2                    ;0 if GS/OS storage allocated, 1 if not
1297 D68F                       EXPORT e1_OS_switch
1298 D68F 00 00        e1_OS_switch DC W:0                     ;1 if switching operating systems, 0 if not
1299 D691                       EXPORT e1_mslot
1300 D691 C7 00        e1_mslot DS B:2                         ;boot slot #
1301 D693                       EXPORT e1_c3_status
1302 D693 00 00        e1_c3_status DS B:2                     ;slot 3 rom status
1303 D695                       EXPORT e1_besc
1304 D695 00 00        e1_besc  DS B:2                         ;bit encoded slot configuration
1305 D697                       EXPORT e1_zp_handle
1306 D697 00 65 E0 00  e1_zp_handle DC L:0                     ;handle to user's zp segment (init to 0)
1307 D69B                       EXPORT e1_zp_start
1308 D69B 00 08        e1_zp_start DS B:2                      ;address of start of user's zp segment
1309 D69D                       EXPORT e1_zp_size
1310 D69D 00 10        e1_zp_size DS B:2                       ;size of user's zp segment
1311 D69F                       EXPORT e1_id_stack_index
1312 D69F 00 00        e1_id_stack_index DC W:0                ;ID stack pointer (init to 0)
1313 D6A1                       EXPORT e1_id_stack
1314 D6A1 00 00 00 00  e1_id_stack DS B:64                     ;IDs of programs to return to
1315 D6E1
1316 D6E1              ; The following 8 bytes are used for storing the load addresses of the two QuickDraw patches
1317 D6E1              ; which are contained at the front of the error messages file.
1318 D6E1
1319 D6E1                       EXPORT e1_patch1_adr
1320 D6E1 00 00 02 00  e1_patch1_adr DC L:0
1321 D6E5                       EXPORT e1_patch2_adr
1322 D6E5 0D 00 02 00  e1_patch2_adr DC L:0
1323 D6E9
1324 D6E9              ; The following word is accessed by the report_fatal routine in SCM to determine
1325 D6E9              ; if GS/OS should be shutdown before the system is reset.
1326 D6E9
1327 D6E9                       EXPORT e1_gsos_ok
1328 D6E9 01 00        e1_gsos_ok DC W:0                       ;1 if GS/OS is up and running, 0 if not
1329 D6EB
1330 D6EB              ; The following 4 bytes are used for storing the load address of the file
1331 D6EB              ; */SYSTEM/GS.OS.DEV
1332 D6EB
1333 D6EB                       EXPORT e1_dev_address
1334 D6EB 1F 15 02 00  e1_dev_address DS B:4
1335 D6EF
1336 D6EF              ; The following 4 bytes are used for storing the load address of the file
1337 D6EF              ; */SYSTEM/DRIVERS/BOOT.DRIVER
1338 D6EF
1339 D6EF                       EXPORT e1_drvr_address
1340 D6EF 00 00 00 00  e1_drvr_address DC L:0                  ;initialized to nil
1341 D6F3
1342 D6F3              ; The following 4 bytes are used for storing the load address of the file
1343 D6F3              ; */SYSTEM/ERROR.MSG
1344 D6F3
1345 D6F3                       EXPORT e1_msg_address
1346 D6F3 1A 00 02 00  e1_msg_address DS B:4                   ;accessed by SCM
1347 D6F7
1348 D6F7              ; The following bytes are used for storing the name of the boot volume
1349 D6F7              ; in class 1 format beginning with a colon.
1350 D6F7
1351 D6F7                       EXPORT e1_volname
1352 D6F7 05 00 3A 49  e1_volname DS B:35                      ;accessed by SCM
1353 D71A
1354 D71A              ; The following bytes are used for storing the application's filename
1355 D71A              ; in class 0 format with no separators.
1356 D71A
1357 D71A                       EXPORT e1_app_filename
1358 D71A 06 46 69 6E  e1_app_filename DS B:33                 ;accessed by SCM
1359 D73B
1360 D73B              ; The following bytes are used for storing the application's volume name or the
1361 D73B              ; boot volume name in class 0 format for the P8 'mount volume' window.
1362 D73B
1363 D73B                       EXPORT e1_app_volname
1364 D73B 05 2F 49 41  e1_app_volname DS B:35
1365 D75E
1366 D75E              ;Class 0 string containing the pathname of the start program.
1367 D75E              ;Maximum length of pathname is 67 bytes as follows - length (1 byte),
1368 D75E              ;slash (1 byte), volume name (32 bytes), slash (1 byte), filename (32 bytes)
1369 D75E
1370 D75E                       EXPORT e1_start_prog0
1371 D75E 12 2F 49 41  e1_start_prog0 DS B:67
1372 D7A1
1373 D7A1              ;Class 1 string containing the pathname of the start program.
1374 D7A1              ;Maximum length of pathname is 68 bytes as follows - length (2 bytes), separator
1375 D7A1              ;(1 byte), volume name (32 bytes), separator (1 byte), filename (32 bytes)
1376 D7A1
1377 D7A1                       EXPORT e1_start_prog1
1378 D7A1 12 00 3A 49  e1_start_prog1 DS B:68
1379 D7E5
1380 D7E5              ; The following bytes are used for storing the pathname specified in a P8
1381 D7E5              ; Quit call.  We need 67 bytes since the pathname may be converted to class 1.
1382 D7E5
1383 D7E5                       EXPORT e1_p8quit_path
1384 D7E5 00 00 00 00  e1_p8quit_path DS B:67
1385 D828
1386 D828              ; The following bytes are used for storing a prefix which came from P8
1387 D828              ; or which will be used to set P8's prefix.
1388 D828              ; The first 2 bytes are for the buffer size when making a class 1 GetPrefix
1389 D828              ; call.  The next 67 bytes are used for - length (2 bytes),
1390 D828              ; prefix (64 bytes - the P8 maximum), trailing slash (1 byte).
1391 D828
1392 D828                       EXPORT e1_prefix_buf1
1393 D828 45 00        e1_prefix_buf1 DC W:69                  ;size header for class 1 output string
1394 D82A                       EXPORT e1_prefix_buf
1395 D82A 00 00 00 00  e1_prefix_buf DS B:67                   ;must follow e1_prefix_buf1
1396 D86D
1397 D86D              ; The following bytes are used when setting prefix 1 to a null string
1398 D86D              ; and when making a Volume call
1399 D86D
1400 D86D                       EXPORT e1_null_str
1401 D86D 00 00        e1_null_str DC W:0                      ;a null string
1402 D86F
1403 D86F              ; The following bytes are used for temporarily saving bank $00 data when making
1404 D86F              ; ProDOS 8 calls from the get_info_sub routine
1405 D86F
1406 D86F                       EXPORT e1_bank0_save
1407 D86F 00 00 00 00  e1_bank0_save DS B:bank0_area_used
1408 D8DA
1409 D8DA              ; This buffer is used for Int2Hex calls.
1410 D8DA
1411 D8DA                       Entry e1_errStr,e1_errBuf
1412 D8DA 04           e1_errStr DC B:4                        ;length byte (always 4 characters)
1413 D8DB 00 00 00 00  e1_errBuf DS B:4                        ;space for hex digits
1414 D8DF
1415 D8DF                       ENDP 
1416 D8DF
1417 D8DF
1418 D8DF                       eject 
1419 D8DF              ;===============================================================================
1420 D8DF              ;
1421 D8DF              ; e1_strings
1422 D8DF              ;
1423 D8DF              ;===============================================================================
1424 D8DF
1425 D8DF              e1_strings PROC 
1426 D8DF
1427 D8DF                       EXPORT e1_sys_filename
1428 D8DF                       EXPORT e1_p8_path
1429 D8DF                       EXPORT e1_lib_path
1430 D8DF                       EXPORT e1_cons_path
1431 D8DF                       EXPORT e1_fatal_msg
1432 D8DF                       EXPORT e1_mount_msg
1433 D8DF                       EXPORT e1_btn1_label
1434 D8DF                       EXPORT e1_btn2_label
1435 D8DF
1436 D8DF 0D           e1_sys_filename DC B:13                 ;class 0 string
1437 D8E0 3A 53 59 53           DC B:':SYSTEM:START'
1438 D8ED 00 00 00 00           DS B:20                        ;extra space needed for 32 char name
1439 D901
1440 D901 0B 00        e1_p8_path DC W:11                      ;class 1 string
1441 D903 2A 3A 53 59           DC B:'*:SYSTEM:P8'
1442 D90E
1443 D90E 0D 00        e1_lib_path DC W:13                     ;class 1 string
1444 D910 2A 3A 53 59           DC B:'*:SYSTEM:LIBS'
1445 D91D
1446 D91D 08 00        e1_cons_path DC W:8                     ;class 1 string
1447 D91F 2E 43 4F 4E           DC B:'.CONSOLE'
1448 D927
1449 D927
1450 D927              ;-------------------------------------------------------------------------------
1451 D927              ; Message for P8_Fatal_Error routine
1452 D927              ;-------------------------------------------------------------------------------
1453 D927
1454 D927              ; The maximum length of this message is 35 characters.
1455 D927              ; (The error code will be displayed immediately following the final character.)
1456 D927
1457 D927 23           e1_fatal_msg DC B:35                    ; Length byte
1458 D928 43 61 6E              DC B:'Can'
1459 D92B 27                    DC B:$27
1460 D92C 74 20 72 75           DC B:'t run next application. Error=$'
1461 D94B
1462 D94B
1463 D94B              ;-------------------------------------------------------------------------------
1464 D94B              ; Messages for P8_Mount_Vol routine
1465 D94B              ;-------------------------------------------------------------------------------
1466 D94B
1467 D94B              ; The maximum length of this message is 35 characters.
1468 D94B              ; The button labels must not be more than 16 characters.
1469 D94B
1470 D94B 17 50 6C 65  e1_mount_msg DC C:'Please insert the disk:'
1471 D963
1472 D963 0D           e1_btn1_label DC B:13
1473 D964 41 63 63 65           DC B:'Accept: '
1474 D96C 1B                    DC B:$1b                       ;Basic turn mousetext on code
1475 D96D 0F                    DC B:$0f                       ;Basic turn inverse mode on
1476 D96E 4D                    DC B:$4d                       ;Mousetest return character
1477 D96F 0E                    DC B:$0e                       ;Basic turn normal mode on
1478 D970 18                    DC B:$18                       ;Basic turn mousetext off code
1479 D971
1480 D971 0B 43 61 6E  e1_btn2_label DC C:'Cancel: Esc'
1481 D97D
1482 D97D                       ENDP 
1483 D97D
1484 D97D
1485 D97D                       EXPORT e1_end
1486 D97D              e1_end   PROC 
1487 D97D                       ENDP 
1488 D97D
1489 D97D
1490 D97D              *********************************************************************************
1491 D97D              org_dummy_8 proc org e1_obj_max, skip   ;generate an error if E1 code
1492 D97D                       endp                           ;is too big
1493 D97D              *********************************************************************************
1494 D97D
1495 D97D
1496 D97D                       END   
